
;(function($) {

  $.fn.lazyLoad = function(threshold) {

    var $w = $(window),
        th = threshold || 0,
        retina = window.devicePixelRatio > 1,
        ajaxes = this,
        loaded,
        inview,
        source,
        delay;
    
    this.one("lazyLoad", function () {
        callback = this.getAttribute("data-lazyload-callback");
        window[callback](this);
        this.setAttribute("data-loaded", true);
    });

    function lazyLoad() {
        inview = ajaxes.filter(function () {
        var $e = $(this),
            wt = $w.scrollTop(),
            wb = wt + $w.height(),
            et = $e.offset().top,
            eb = et + $e.height();

        return $e.is(":visible") && eb >= wt - th && et <= wb + th;
      });

      loaded = inview.trigger("lazyLoad");
      ajaxes = ajaxes.not(loaded);
    }

    function delayedLazyLoad() {
        clearTimeout(delay);
        delay = setTimeout(lazyLoad, 700);
    }

    $w.on("scroll", delayedLazyLoad);
    $w.on("resize", delayedLazyLoad);

    delayedLazyLoad();

    return this;

  };

})(jQuery);


